import 'package:flutter/cupertino.dart';

class Dimensions {
  static const double fontExtraSmall = 10.0;
  static const double fontOverSmall = 7.0;
  static const double fontSmall = 12.0;
  static const double fontDefault = 14.0;
  static const double fontLarge = 16.0;
  static const double fontExtraLarge = 17.0;
  static const double fontOverLarge = 20.0;
  static const double fontHeader = 24.0;

  static const double paddingSizeExtraSmall = 5.0;
  static const double paddingSizeSmall = 10.0;
  static const double paddingSizeDefault = 15.0;
  static const double paddingSizeLarge = 20.0;
  static const double paddingSizeExtraLarge = 25.0;

  static const double horizontalPaddingForLV = 12;
  static const double authTextSize = 13;
  static const double verticalPaddingForLV = 10;
  static const double radius = 10;

  static const double horizontalMargin = 6;
  static const double verticalMargin = 6;
  static const double fieldHeight = 50;
  static const EdgeInsets screenPaddingHV = EdgeInsets.only(left: space15, right: space15, top: space20);
  static const EdgeInsets padding = EdgeInsets.symmetric(horizontal: horizontalPaddingForLV, vertical: verticalPaddingForLV);
  static const EdgeInsets lvContainerMargin = EdgeInsets.symmetric(horizontal: horizontalMargin, vertical: verticalMargin);

  static const EdgeInsets dialogContainerMargin = EdgeInsets.symmetric(horizontal: horizontalPaddingForLV, vertical: verticalPaddingForLV);

  static const double cornerRadius = 4;
  static const double space5 = 4;
  static const double space8 = 8;
  static const double space10 = 10;
  static const double space12 = 12;
  static const double space15 = 15;
  static const double space20 = 20;
  static const double space30 = 30;
  static const double space50 = 50;

  static const double marginTop = 12;
  static const SizedBox labelSizedBox = SizedBox(
    height: 15,
  );
  static const double pageTopMargin = 15;
  static const double pageLeftRightMargin = 10;

  static const double homePageLeftMargin = 10;
  static const double homePageRightMargin = 10;

  static const double spaceBetweenCategory = 10;
  static const double spaceBetweenTextAndImage = 10;

  static const double gridViewCrossAxisSpacing = 10;
  static const double gridViewMainAxisSpacing = 10;

  static const double cardRadius = 4;
  static const double mediumRadius = 8;
  static const double largeRadius = 12;
  static const double extraRadius = 16;
  static const double textToTextSpace = 8;
}
